﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class HatScript : MonoBehaviour
{

    public bool hatActive = false;
    public GameObject helicoHatPlayer;
    public GameObject player;
    private bool hatTimerBool; 
    private int hatTimer = 0;

    public float time = 0;
    public int timeInt;

    public GameObject platformPrefab;
    public GameObject springPrefab;
    public GameObject brokenPlatformPrefab;


    // Start is called before the first frame update
    void Start()
    {
	helicoHatPlayer.SetActive(false);
    }

     void Update()
    {
	//lancement d'un compteur
        timeInt = Mathf.RoundToInt(time);


	//si le perso a activé un chapeau à hélice
        if (hatActive)
        {
		
            //on change son rigidbody en kinematic pour continuer à gagner des points quand le perso s'envole
	    this.GetComponent<Rigidbody2D>().bodyType = RigidbodyType2D.Kinematic;

	    //on le fait monter rapidement vers le haut
	    this.transform.Translate(Vector3.up * Time.deltaTime * 40);

	    //le chapeau doit durer 5s
            if(hatTimerBool){
		hatTimer = timeInt + 5;
		hatTimerBool = false;
	    }
	    
	    //si le compteur est à 5s
	    //on remet le rigidbody en dynamic et on supprime les effets du chapeau et l'apparence du joueur

	    if(timeInt == hatTimer){	    
            	helicoHatPlayer.SetActive(false);
    	   	hatActive = false;
	   	this.GetComponent<Rigidbody2D>().bodyType = RigidbodyType2D.Dynamic;
	    }

	//on incrémente le compteur
        time += Time.deltaTime;

        }
    }

    private void OnCollisionEnter2D (Collision2D collision)
    {

	//si le joueur fait collision avec un chapeau, on active l'apparence du chapeau et on supprime celui issu de la map

        if (collision.gameObject.name == "helicoHatMap" || collision.gameObject.name == "helicoHatMap(Clone)")
        {
    	    hatActive = true;
	    hatTimerBool = true;
            helicoHatPlayer.SetActive(true);
	    Destroy(GameObject.Find("helicoHatMap(Clone)"));	
        }
    }

}
